import { BaseRecord } from '@tldraw/store';
import { Expand } from '@tldraw/utils';
import { IndexKey } from '@tldraw/utils';
import { JsonObject } from '@tldraw/utils';
import { LegacyMigrations } from '@tldraw/store';
import { MigrationId } from '@tldraw/store';
import { MigrationSequence } from '@tldraw/store';
import { RecordId } from '@tldraw/store';
import { RecordType } from '@tldraw/store';
import { SerializedStore } from '@tldraw/store';
import { Signal } from '@tldraw/state';
import { StandaloneDependsOn } from '@tldraw/store';
import { Store } from '@tldraw/store';
import { StoreSchema } from '@tldraw/store';
import { StoreSnapshot } from '@tldraw/store';
import { StoreValidator } from '@tldraw/store';
import { T } from '@tldraw/validate';
import { UnknownRecord } from '@tldraw/store';

/** @public */
export declare const arrowBindingMigrations: TLPropsMigrations;

/** @public */
export declare const arrowBindingProps: RecordProps<TLArrowBinding>;

/** @public */
export declare const ArrowShapeArrowheadEndStyle: EnumStyleProp<"arrow" | "bar" | "diamond" | "dot" | "inverted" | "none" | "pipe" | "square" | "triangle">;

/** @public */
export declare const ArrowShapeArrowheadStartStyle: EnumStyleProp<"arrow" | "bar" | "diamond" | "dot" | "inverted" | "none" | "pipe" | "square" | "triangle">;

/** @public */
export declare const arrowShapeMigrations: MigrationSequence;

/** @public */
export declare const arrowShapeProps: RecordProps<TLArrowShape>;

/**
 * A validator for asset record type Ids.
 *
 * @public */
export declare const assetIdValidator: T.Validator<TLAssetId>;

/** @public */
export declare const assetMigrations: MigrationSequence;

/** @public */
export declare const AssetRecordType: RecordType<TLAsset, "props" | "type">;

/** @public */
export declare const assetValidator: T.Validator<TLAsset>;

/** @public */
export declare const bindingIdValidator: T.Validator<TLBindingId>;

/** @public */
export declare const bookmarkShapeMigrations: TLPropsMigrations;

/** @public */
export declare const bookmarkShapeProps: RecordProps<TLBookmarkShape>;

/**
 * A serializable model for 2D boxes.
 *
 * @public */
export declare interface BoxModel {
    x: number;
    y: number;
    w: number;
    h: number;
}

/** @public */
export declare const boxModelValidator: T.ObjectValidator<BoxModel>;

/** @public */
export declare const CameraRecordType: RecordType<TLCamera, never>;

/**
 * A validator for the colors used by tldraw's default shapes.
 *
 * @public */
export declare const canvasUiColorTypeValidator: T.Validator<"accent" | "black" | "laser" | "muted-1" | "selection-fill" | "selection-stroke" | "white">;

/**
 * Create a validator for an asset record type.
 *
 * @param type - The type of the asset
 * @param props - The validator for the asset's props
 *
 * @public */
export declare function createAssetValidator<Type extends string, Props extends JsonObject>(type: Type, props: T.Validator<Props>): T.ObjectValidator<Expand<    { [P in T.ExtractRequiredKeys<{
id: TLAssetId;
meta: JsonObject;
props: Props;
type: Type;
typeName: 'asset';
}>]: {
id: TLAssetId;
meta: JsonObject;
props: Props;
type: Type;
typeName: 'asset';
}[P]; } & { [P_1 in T.ExtractOptionalKeys<{
id: TLAssetId;
meta: JsonObject;
props: Props;
type: Type;
typeName: 'asset';
}>]?: {
id: TLAssetId;
meta: JsonObject;
props: Props;
type: Type;
typeName: 'asset';
}[P_1] | undefined; }>>;

/** @public */
export declare function createBindingId(id?: string): TLBindingId;

/**
 * @public
 */
export declare function createBindingPropsMigrationIds<S extends string, T extends Record<string, number>>(bindingType: S, ids: T): {
    [k in keyof T]: `com.tldraw.binding.${S}/${T[k]}`;
};

/**
 * @public
 */
export declare function createBindingPropsMigrationSequence(migrations: TLPropsMigrations): TLPropsMigrations;

/** @public */
export declare function createBindingValidator<Type extends string, Props extends JsonObject, Meta extends JsonObject>(type: Type, props?: {
    [K in keyof Props]: T.Validatable<Props[K]>;
}, meta?: {
    [K in keyof Meta]: T.Validatable<Meta[K]>;
}): T.ObjectValidator<Expand<    { [P in T.ExtractRequiredKeys<TLBaseBinding<Type, Props>>]: TLBaseBinding<Type, Props>[P]; } & { [P_1 in T.ExtractOptionalKeys<TLBaseBinding<Type, Props>>]?: TLBaseBinding<Type, Props>[P_1] | undefined; }>>;

/**
 * Creates a derivation that represents the current presence state of the current user.
 * @public
 */
export declare const createPresenceStateDerivation: ($user: Signal<{
    color: string;
    id: string;
    name: string;
}>, instanceId?: TLInstancePresence['id']) => (store: TLStore) => Signal<null | TLInstancePresence>;

/** @public */
export declare function createShapeId(id?: string): TLShapeId;

/**
 * @public
 */
export declare function createShapePropsMigrationIds<const S extends string, const T extends Record<string, number>>(shapeType: S, ids: T): {
    [k in keyof T]: `com.tldraw.shape.${S}/${T[k]}`;
};

/**
 * @public
 */
export declare function createShapePropsMigrationSequence(migrations: TLPropsMigrations): TLPropsMigrations;

/** @public */
export declare function createShapeValidator<Type extends string, Props extends JsonObject, Meta extends JsonObject>(type: Type, props?: {
    [K in keyof Props]: T.Validatable<Props[K]>;
}, meta?: {
    [K in keyof Meta]: T.Validatable<Meta[K]>;
}): T.ObjectValidator<Expand<    { [P in T.ExtractRequiredKeys<TLBaseShape<Type, Props>>]: TLBaseShape<Type, Props>[P]; } & { [P_1 in T.ExtractOptionalKeys<TLBaseShape<Type, Props>>]?: TLBaseShape<Type, Props>[P_1] | undefined; }>>;

/**
 * Create a TLSchema with custom shapes. Custom shapes cannot override default shapes.
 *
 * @param opts - Options
 *
 * @public */
export declare function createTLSchema({ shapes, bindings, migrations, }?: {
    bindings?: Record<string, SchemaPropsInfo>;
    migrations?: readonly MigrationSequence[];
    shapes?: Record<string, SchemaPropsInfo>;
}): TLSchema;

/** @public */
export declare const defaultBindingSchemas: {
    arrow: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLArrowBinding>;
    };
};

/** @public */
export declare const defaultColorNames: readonly ["black", "grey", "light-violet", "violet", "blue", "light-blue", "yellow", "orange", "green", "light-green", "light-red", "red", "white"];

/** @public */
export declare const DefaultColorStyle: EnumStyleProp<"black" | "blue" | "green" | "grey" | "light-blue" | "light-green" | "light-red" | "light-violet" | "orange" | "red" | "violet" | "white" | "yellow">;

/** @public */
export declare const DefaultColorThemePalette: {
    darkMode: TLDefaultColorTheme;
    lightMode: TLDefaultColorTheme;
};

/** @public */
export declare const DefaultDashStyle: EnumStyleProp<"dashed" | "dotted" | "draw" | "solid">;

/** @public */
export declare const DefaultFillStyle: EnumStyleProp<"fill" | "none" | "pattern" | "semi" | "solid">;

/** @public */
export declare const DefaultFontFamilies: {
    draw: string;
    mono: string;
    sans: string;
    serif: string;
};

/** @public */
export declare const DefaultFontStyle: EnumStyleProp<"draw" | "mono" | "sans" | "serif">;

/** @public */
export declare const DefaultHorizontalAlignStyle: EnumStyleProp<"end-legacy" | "end" | "middle-legacy" | "middle" | "start-legacy" | "start">;

/** @public */
export declare const defaultShapeSchemas: {
    arrow: {
        migrations: MigrationSequence;
        props: RecordProps<TLArrowShape>;
    };
    bookmark: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLBookmarkShape>;
    };
    draw: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLDrawShape>;
    };
    embed: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLEmbedShape>;
    };
    frame: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLFrameShape>;
    };
    geo: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLGeoShape>;
    };
    group: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLGroupShape>;
    };
    highlight: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLHighlightShape>;
    };
    image: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLImageShape>;
    };
    line: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLLineShape>;
    };
    note: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLNoteShape>;
    };
    text: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLTextShape>;
    };
    video: {
        migrations: TLPropsMigrations;
        props: RecordProps<TLVideoShape>;
    };
};

/** @public */
export declare const DefaultSizeStyle: EnumStyleProp<"l" | "m" | "s" | "xl">;

/** @public */
export declare const DefaultTextAlignStyle: EnumStyleProp<"end" | "middle" | "start">;

/** @public */
export declare const DefaultVerticalAlignStyle: EnumStyleProp<"end" | "middle" | "start">;

/** @public */
export declare const DocumentRecordType: RecordType<TLDocument, never>;

/** @public */
export declare const drawShapeMigrations: TLPropsMigrations;

/** @public */
export declare const drawShapeProps: RecordProps<TLDrawShape>;

/** @public */
export declare const EMBED_DEFINITIONS: readonly [{
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["beta.tldraw.com", "tldraw.com", "localhost:3000"];
    readonly minHeight: 300;
    readonly minWidth: 300;
    readonly overridePermissions: {
        readonly 'allow-top-navigation': true;
    };
    readonly title: "tldraw";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "tldraw";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["figma.com"];
    readonly title: "Figma";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "figma";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["google.*"];
    readonly overridePermissions: {
        readonly 'allow-presentation': true;
    };
    readonly title: "Google Maps";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "google_maps";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["val.town"];
    readonly minHeight: 100;
    readonly minWidth: 260;
    readonly title: "Val Town";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "val_town";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["codesandbox.io"];
    readonly minHeight: 300;
    readonly minWidth: 300;
    readonly title: "CodeSandbox";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "codesandbox";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 400;
    readonly hostnames: readonly ["codepen.io"];
    readonly minHeight: 300;
    readonly minWidth: 300;
    readonly title: "Codepen";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "codepen";
    readonly width: 520;
}, {
    readonly doesResize: false;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 400;
    readonly hostnames: readonly ["scratch.mit.edu"];
    readonly title: "Scratch";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "scratch";
    readonly width: 520;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 450;
    readonly hostnames: readonly ["*.youtube.com", "youtube.com", "youtu.be"];
    readonly isAspectRatioLocked: true;
    readonly overridePermissions: {
        readonly 'allow-popups-to-escape-sandbox': true;
        readonly 'allow-presentation': true;
    };
    readonly title: "YouTube";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "youtube";
    readonly width: 800;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["calendar.google.*"];
    readonly instructionLink: "https://support.google.com/calendar/answer/41207?hl=en";
    readonly minHeight: 360;
    readonly minWidth: 460;
    readonly overridePermissions: {
        readonly 'allow-popups-to-escape-sandbox': true;
    };
    readonly title: "Google Calendar";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "google_calendar";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["docs.google.*"];
    readonly minHeight: 360;
    readonly minWidth: 460;
    readonly overridePermissions: {
        readonly 'allow-popups-to-escape-sandbox': true;
    };
    readonly title: "Google Slides";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "google_slides";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["gist.github.com"];
    readonly title: "GitHub Gist";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "github_gist";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["replit.com"];
    readonly title: "Replit";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "replit";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["felt.com"];
    readonly title: "Felt";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "felt";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["open.spotify.com"];
    readonly minHeight: 500;
    readonly overrideOutlineRadius: 12;
    readonly title: "Spotify";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "spotify";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 360;
    readonly hostnames: readonly ["vimeo.com", "player.vimeo.com"];
    readonly isAspectRatioLocked: true;
    readonly title: "Vimeo";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "vimeo";
    readonly width: 640;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["excalidraw.com"];
    readonly isAspectRatioLocked: true;
    readonly title: "Excalidraw";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "excalidraw";
    readonly width: 720;
}, {
    readonly backgroundColor: "#fff";
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 500;
    readonly hostnames: readonly ["observablehq.com"];
    readonly isAspectRatioLocked: false;
    readonly title: "Observable";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "observable";
    readonly width: 720;
}, {
    readonly doesResize: true;
    readonly fromEmbedUrl: (url: string) => string | undefined;
    readonly height: 450;
    readonly hostnames: readonly ["desmos.com"];
    readonly title: "Desmos";
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly type: "desmos";
    readonly width: 700;
}];

/** @public */
export declare interface EmbedDefinition {
    readonly type: string;
    readonly title: string;
    readonly hostnames: readonly string[];
    readonly minWidth?: number;
    readonly minHeight?: number;
    readonly width: number;
    readonly height: number;
    readonly doesResize: boolean;
    readonly isAspectRatioLocked?: boolean;
    readonly overridePermissions?: TLEmbedShapePermissions;
    readonly instructionLink?: string;
    readonly backgroundColor?: string;
    readonly overrideOutlineRadius?: number;
    readonly toEmbedUrl: (url: string) => string | undefined;
    readonly fromEmbedUrl: (url: string) => string | undefined;
}

/** @public */
export declare const embedShapeMigrations: TLPropsMigrations;

/**
 * Permissions with note inline from
 * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#attr-sandbox
 *
 * @public
 */
export declare const embedShapePermissionDefaults: {
    readonly 'allow-downloads-without-user-activation': false;
    readonly 'allow-downloads': false;
    readonly 'allow-forms': true;
    readonly 'allow-modals': false;
    readonly 'allow-orientation-lock': false;
    readonly 'allow-pointer-lock': false;
    readonly 'allow-popups-to-escape-sandbox': false;
    readonly 'allow-popups': true;
    readonly 'allow-presentation': false;
    readonly 'allow-same-origin': true;
    readonly 'allow-scripts': true;
    readonly 'allow-storage-access-by-user-activation': false;
    readonly 'allow-top-navigation-by-user-activation': false;
    readonly 'allow-top-navigation': false;
};

/** @public */
export declare const embedShapeProps: RecordProps<TLEmbedShape>;

/**
 * See {@link StyleProp} & {@link StyleProp.defineEnum}
 *
 * @public
 */
export declare class EnumStyleProp<T> extends StyleProp<T> {
    readonly values: readonly T[];
    /* Excluded from this release type: __constructor */
}

/** @public */
export declare const frameShapeMigrations: TLPropsMigrations;

/** @public */
export declare const frameShapeProps: RecordProps<TLFrameShape>;

/** @public */
export declare const GeoShapeGeoStyle: EnumStyleProp<"arrow-down" | "arrow-left" | "arrow-right" | "arrow-up" | "check-box" | "cloud" | "diamond" | "ellipse" | "heart" | "hexagon" | "octagon" | "oval" | "pentagon" | "rectangle" | "rhombus-2" | "rhombus" | "star" | "trapezoid" | "triangle" | "x-box">;

/** @public */
export declare const geoShapeMigrations: TLPropsMigrations;

/** @public */
export declare const geoShapeProps: RecordProps<TLGeoShape>;

/** @public */
export declare function getDefaultColorTheme(opts: {
    isDarkMode: boolean;
}): TLDefaultColorTheme;

/** @public */
export declare function getDefaultTranslationLocale(): TLLanguage['locale'];

/* Excluded from this release type: getShapePropKeysByStyle */

/** @public */
export declare const groupShapeMigrations: TLPropsMigrations;

/** @public */
export declare const groupShapeProps: RecordProps<TLGroupShape>;

/** @public */
export declare const highlightShapeMigrations: TLPropsMigrations;

/** @public */
export declare const highlightShapeProps: RecordProps<TLHighlightShape>;

/** @public */
export declare function idValidator<Id extends RecordId<UnknownRecord>>(prefix: Id['__type__']['typeName']): T.Validator<Id>;

/** @public */
export declare const ImageShapeCrop: T.ObjectValidator<TLImageShapeCrop>;

/** @public */
export declare const imageShapeMigrations: TLPropsMigrations;

/** @public */
export declare const imageShapeProps: RecordProps<TLImageShape>;

/** @public */
export declare const InstancePageStateRecordType: RecordType<TLInstancePageState, "pageId">;

/** @public */
export declare const InstancePresenceRecordType: RecordType<TLInstancePresence, "currentPageId" | "userId" | "userName">;

/** @public */
export declare function isBinding(record?: UnknownRecord): record is TLBinding;

/** @public */
export declare function isBindingId(id?: string): id is TLBindingId;

/** @public */
export declare function isPageId(id: string): id is TLPageId;

/** @public */
export declare function isShape(record?: UnknownRecord): record is TLShape;

/** @public */
export declare function isShapeId(id?: string): id is TLShapeId;

/** @public */
export declare const LANGUAGES: readonly [{
    readonly label: "Bahasa Indonesia";
    readonly locale: "id";
}, {
    readonly label: "Català";
    readonly locale: "ca";
}, {
    readonly label: "Čeština";
    readonly locale: "cs";
}, {
    readonly label: "Danish";
    readonly locale: "da";
}, {
    readonly label: "Deutsch";
    readonly locale: "de";
}, {
    readonly label: "English";
    readonly locale: "en";
}, {
    readonly label: "Español";
    readonly locale: "es";
}, {
    readonly label: "Français";
    readonly locale: "fr";
}, {
    readonly label: "Galego";
    readonly locale: "gl";
}, {
    readonly label: "Hrvatski";
    readonly locale: "hr";
}, {
    readonly label: "Italiano";
    readonly locale: "it";
}, {
    readonly label: "Magyar";
    readonly locale: "hu";
}, {
    readonly label: "Norwegian";
    readonly locale: "no";
}, {
    readonly label: "Polski";
    readonly locale: "pl";
}, {
    readonly label: "Português - Brasil";
    readonly locale: "pt-br";
}, {
    readonly label: "Português - Europeu";
    readonly locale: "pt-pt";
}, {
    readonly label: "Română";
    readonly locale: "ro";
}, {
    readonly label: "Russian";
    readonly locale: "ru";
}, {
    readonly label: "Slovenščina";
    readonly locale: "sl";
}, {
    readonly label: "Suomi";
    readonly locale: "fi";
}, {
    readonly label: "Svenska";
    readonly locale: "sv";
}, {
    readonly label: "Tiếng Việt";
    readonly locale: "vi";
}, {
    readonly label: "Türkçe";
    readonly locale: "tr";
}, {
    readonly label: "Ukrainian";
    readonly locale: "uk";
}, {
    readonly label: "עברית";
    readonly locale: "he";
}, {
    readonly label: "عربي";
    readonly locale: "ar";
}, {
    readonly label: "فارسی";
    readonly locale: "fa";
}, {
    readonly label: "کوردی";
    readonly locale: "ku";
}, {
    readonly label: "नेपाली";
    readonly locale: "ne";
}, {
    readonly label: "हिन्दी";
    readonly locale: "hi-in";
}, {
    readonly label: "తెలుగు";
    readonly locale: "te";
}, {
    readonly label: "ภาษาไทย";
    readonly locale: "th";
}, {
    readonly label: "မြန်မာစာ";
    readonly locale: "my";
}, {
    readonly label: "한국어";
    readonly locale: "ko-kr";
}, {
    readonly label: "日本語";
    readonly locale: "ja";
}, {
    readonly label: "简体中文";
    readonly locale: "zh-cn";
}, {
    readonly label: "繁體中文 (台灣)";
    readonly locale: "zh-tw";
}];

/** @public */
export declare const lineShapeMigrations: TLPropsMigrations;

/** @public */
export declare const lineShapeProps: RecordProps<TLLineShape>;

/** @public */
export declare const LineShapeSplineStyle: EnumStyleProp<"cubic" | "line">;

/** @public */
export declare const noteShapeMigrations: TLPropsMigrations;

/** @public */
export declare const noteShapeProps: RecordProps<TLNoteShape>;

/** @public */
export declare const opacityValidator: T.Validator<number>;

/** @public */
export declare const pageIdValidator: T.Validator<TLPageId>;

/** @public */
export declare const PageRecordType: RecordType<TLPage, "index" | "name">;

/** @public */
export declare const parentIdValidator: T.Validator<TLParentId>;

/* Excluded from this release type: pluckPreservingValues */

/** @public */
export declare const PointerRecordType: RecordType<TLPointer, never>;

/** @public */
export declare type RecordProps<R extends UnknownRecord & {
    props: object;
}> = {
    [K in keyof R['props']]: T.Validatable<R['props'][K]>;
};

/** @public */
export declare type RecordPropsType<Config extends Record<string, T.Validatable<any>>> = Expand<{
    [K in keyof Config]: T.TypeOf<Config[K]>;
}>;

/** @public */
export declare const rootBindingMigrations: MigrationSequence;

/** @public */
export declare const rootShapeMigrations: MigrationSequence;

/** @public */
export declare interface SchemaPropsInfo {
    migrations?: LegacyMigrations | MigrationSequence | TLPropsMigrations;
    props?: Record<string, StoreValidator<any>>;
    meta?: Record<string, StoreValidator<any>>;
}

/** @public */
export declare const scribbleValidator: T.ObjectValidator<TLScribble>;

/** @public */
export declare type SetValue<T extends Set<any>> = T extends Set<infer U> ? U : never;

/** @public */
export declare const shapeIdValidator: T.Validator<TLShapeId>;

/**
 * A `StyleProp` is a property of a shape that follows some special rules.
 *
 * 1. The same value can be set on lots of shapes at the same time.
 *
 * 2. The last used value is automatically saved and applied to new shapes.
 *
 * For example, {@link DefaultColorStyle} is a style prop used by tldraw's default shapes to set
 * their color. If you try selecting several shapes on tldraw.com and changing their color, you'll
 * see that the color is applied to all of them. Then, if you draw a new shape, it'll have the same
 * color as the one you just set.
 *
 * You can use styles in your own shapes by either defining your own (see {@link StyleProp.define}
 * and {@link StyleProp.defineEnum}) or using tldraw's default ones, like {@link DefaultColorStyle}.
 * When you define a shape, pass a `props` object describing all of your shape's properties, using
 * `StyleProp`s for the ones you want to be styles. See the
 * {@link https://github.com/tldraw/tldraw/tree/main/apps/examples | custom styles example}
 * for more.
 *
 * @public
 */
export declare class StyleProp<Type> implements T.Validatable<Type> {
    readonly id: string;
    defaultValue: Type;
    readonly type: T.Validatable<Type>;
    /**
     * Define a new {@link StyleProp}.
     *
     * @param uniqueId - Each StyleProp must have a unique ID. We recommend you prefix this with
     * your app/library name.
     * @param options -
     * - `defaultValue`: The default value for this style prop.
     *
     * - `type`: Optionally, describe what type of data you expect for this style prop.
     *
     * @example
     * ```ts
     * import {T} from '@tldraw/validate'
     * import {StyleProp} from '@tldraw/tlschema'
     *
     * const MyLineWidthProp = StyleProp.define('myApp:lineWidth', {
     *   defaultValue: 1,
     *   type: T.number,
     * })
     * ```
     * @public
     */
    static define<Type>(uniqueId: string, options: {
        defaultValue: Type;
        type?: T.Validatable<Type>;
    }): StyleProp<Type>;
    /**
     * Define a new {@link StyleProp} as a list of possible values.
     *
     * @param uniqueId - Each StyleProp must have a unique ID. We recommend you prefix this with
     * your app/library name.
     * @param options -
     * - `defaultValue`: The default value for this style prop.
     *
     * - `values`: An array of possible values of this style prop.
     *
     * @example
     * ```ts
     * import {StyleProp} from '@tldraw/tlschema'
     *
     * const MySizeProp = StyleProp.defineEnum('myApp:size', {
     *   defaultValue: 'medium',
     *   values: ['small', 'medium', 'large'],
     * })
     * ```
     */
    static defineEnum<const Values extends readonly unknown[]>(uniqueId: string, options: {
        defaultValue: Values[number];
        values: Values;
    }): EnumStyleProp<Values[number]>;
    /* Excluded from this release type: __constructor */
    setDefaultValue(value: Type): void;
    validate(value: unknown): Type;
    validateUsingKnownGoodVersion(prevValue: Type, newValue: unknown): Type;
}

/**
 * @public
 */
export declare type StylePropValue<T extends StyleProp<any>> = T extends StyleProp<infer U> ? U : never;

/** @public */
export declare const textShapeMigrations: TLPropsMigrations;

/** @public */
export declare const textShapeProps: RecordProps<TLTextShape>;

/**
 * The colors used by tldraw's default shapes.
 *
 *  @public */
export declare const TL_CANVAS_UI_COLOR_TYPES: Set<"accent" | "black" | "laser" | "muted-1" | "selection-fill" | "selection-stroke" | "white">;

/**
 * The cursor types used by tldraw's default shapes.
 *
 * @public */
export declare const TL_CURSOR_TYPES: Set<string>;

/**
 * The handle types used by tldraw's default shapes.
 *
 * @public */
export declare const TL_HANDLE_TYPES: Set<"clone" | "create" | "vertex" | "virtual">;

/**
 * The scribble states used by tldraw.
 *
 *  @public */
export declare const TL_SCRIBBLE_STATES: Set<"active" | "paused" | "starting" | "stopping">;

/** @public */
export declare type TLArrowBinding = TLBaseBinding<'arrow', TLArrowBindingProps>;

/** @public */
export declare interface TLArrowBindingProps {
    terminal: 'end' | 'start';
    normalizedAnchor: VecModel;
    /**
     * exact is whether the arrow head 'enters' the bound shape to point directly at the binding
     * anchor point
     */
    isExact: boolean;
    /**
     * precise is whether to bind to the normalizedAnchor, or to the middle of the shape
     */
    isPrecise: boolean;
}

/** @public */
export declare type TLArrowShape = TLBaseShape<'arrow', TLArrowShapeProps>;

/** @public */
export declare type TLArrowShapeArrowheadStyle = T.TypeOf<typeof ArrowShapeArrowheadStartStyle>;

/** @public */
export declare interface TLArrowShapeProps {
    labelColor: TLDefaultColorStyle;
    color: TLDefaultColorStyle;
    fill: TLDefaultFillStyle;
    dash: TLDefaultDashStyle;
    size: TLDefaultSizeStyle;
    arrowheadStart: TLArrowShapeArrowheadStyle;
    arrowheadEnd: TLArrowShapeArrowheadStyle;
    font: TLDefaultFontStyle;
    start: VecModel;
    end: VecModel;
    bend: number;
    text: string;
    labelPosition: number;
    scale: number;
}

/** @public */
export declare type TLAsset = TLBookmarkAsset | TLImageAsset | TLVideoAsset;

/** @public */
export declare interface TLAssetContext {
    screenScale: number;
    steppedScreenScale: number;
    dpr: number;
    networkEffectiveType: null | string;
    shouldResolveToOriginal: boolean;
}

/** @public */
export declare type TLAssetId = RecordId<TLBaseAsset<any, any>>;

/** @public */
export declare type TLAssetPartial<T extends TLAsset = TLAsset> = T extends T ? {
    id: TLAssetId;
    meta?: Partial<T['meta']>;
    props?: Partial<T['props']>;
    type: T['type'];
} & Partial<Omit<T, 'id' | 'meta' | 'props' | 'type'>> : never;

/** @public */
export declare type TLAssetShape = Extract<TLShape, {
    props: {
        assetId: TLAssetId;
    };
}>;

/**
 * A `TLAssetStore` sits alongside the main {@link TLStore} and is responsible for storing and
 * retrieving large assets such as images. Generally, this should be part of a wider sync system:
 *
 * - By default, the store is in-memory only, so `TLAssetStore` converts images to data URLs
 * - When using
 *   {@link @tldraw/editor#TldrawEditorWithoutStoreProps.persistenceKey | `persistenceKey`}, the
 *   store is synced to the browser's local IndexedDB, so `TLAssetStore` stores images there too
 * - When using a multiplayer sync server, you would implement `TLAssetStore` to upload images to
 *   e.g. an S3 bucket.
 *
 * @public
 */
export declare interface TLAssetStore {
    /**
     * Upload an asset to your storage, returning a URL that can be used to refer to the asset
     * long-term.
     *
     * @param asset - Information & metadata about the asset being uploaded
     * @param file - The `File` to be uploaded
     * @returns A promise that resolves to the URL of the uploaded asset
     */
    upload(asset: TLAsset, file: File): Promise<string>;
    /**
     * Resolve an asset to a URL. This is used when rendering the asset in the editor. By default,
     * this will just use `asset.props.src`, the URL returned by `upload()`. This can be used to
     * rewrite that URL to add access credentials, or optimized the asset for how it's currently
     * being displayed using the {@link TLAssetContext | information provided}.
     *
     * @param asset - the asset being resolved
     * @param ctx - information about the current environment and where the asset is being used
     * @returns The URL of the resolved asset, or `null` if the asset is not available
     */
    resolve?(asset: TLAsset, ctx: TLAssetContext): null | Promise<null | string> | string;
}

/** @public */
export declare interface TLBaseAsset<Type extends string, Props> extends BaseRecord<'asset', TLAssetId> {
    type: Type;
    props: Props;
    meta: JsonObject;
}

/** @public */
export declare interface TLBaseBinding<Type extends string, Props extends object> extends BaseRecord<'binding', TLBindingId> {
    type: Type;
    fromId: TLShapeId;
    toId: TLShapeId;
    props: Props;
    meta: JsonObject;
}

/** @public */
export declare interface TLBaseShape<Type extends string, Props extends object> extends BaseRecord<'shape', TLShapeId> {
    type: Type;
    x: number;
    y: number;
    rotation: number;
    index: IndexKey;
    parentId: TLParentId;
    isLocked: boolean;
    opacity: TLOpacityType;
    props: Props;
    meta: JsonObject;
}

/**
 * The set of all bindings that are available in the editor, including unknown bindings.
 *
 * @public
 */
export declare type TLBinding = TLDefaultBinding | TLUnknownBinding;

/** @public */
export declare type TLBindingCreate<T extends TLBinding = TLBinding> = Expand<{
    fromId: T['fromId'];
    id?: TLBindingId;
    meta?: Partial<T['meta']>;
    props?: Partial<T['props']>;
    toId: T['toId'];
    type: T['type'];
    typeName?: T['typeName'];
}>;

/**
 * An ID for a {@link TLBinding}.
 *
 * @public
 */
export declare type TLBindingId = RecordId<TLUnknownBinding>;

/** @public */
export declare type TLBindingUpdate<T extends TLBinding = TLBinding> = Expand<{
    fromId?: T['fromId'];
    id: TLBindingId;
    meta?: Partial<T['meta']>;
    props?: Partial<T['props']>;
    toId?: T['toId'];
    type: T['type'];
    typeName?: T['typeName'];
}>;

/**
 * An asset used for URL bookmarks, used by the TLBookmarkShape.
 *
 *  @public */
export declare type TLBookmarkAsset = TLBaseAsset<'bookmark', {
    description: string;
    favicon: string;
    image: string;
    src: null | string;
    title: string;
}>;

/** @public */
export declare type TLBookmarkShape = TLBaseShape<'bookmark', TLBookmarkShapeProps>;

/** @public */
export declare interface TLBookmarkShapeProps {
    w: number;
    h: number;
    assetId: null | TLAssetId;
    url: string;
}

/**
 * A camera record.
 *
 * @public
 */
export declare interface TLCamera extends BaseRecord<'camera', TLCameraId> {
    x: number;
    y: number;
    z: number;
    meta: JsonObject;
}

/**
 * The id of a camera record.
 *
 * @public */
export declare type TLCameraId = RecordId<TLCamera>;

/**
 * A type for the colors used by tldraw's default shapes.
 *
 *  @public */
export declare type TLCanvasUiColor = SetValue<typeof TL_CANVAS_UI_COLOR_TYPES>;

/**
 * A cursor used by tldraw.
 *
 *  @public */
export declare interface TLCursor {
    type: TLCursorType;
    rotation: number;
}

/**
 * A type for the cursor types used by tldraw's default shapes.
 *
 *  @public */
export declare type TLCursorType = SetValue<typeof TL_CURSOR_TYPES>;

/**
 * The default set of bindings that are available in the editor.
 *
 * @public */
export declare type TLDefaultBinding = TLArrowBinding;

/** @public */
export declare type TLDefaultColorStyle = T.TypeOf<typeof DefaultColorStyle>;

/** @public */
export declare type TLDefaultColorTheme = Expand<{
    background: string;
    id: 'dark' | 'light';
    solid: string;
    text: string;
} & Record<(typeof defaultColorNames)[number], TLDefaultColorThemeColor>>;

/** @public */
export declare interface TLDefaultColorThemeColor {
    solid: string;
    semi: string;
    pattern: string;
    fill: string;
    note: {
        fill: string;
        text: string;
    };
    highlight: {
        p3: string;
        srgb: string;
    };
}

/** @public */
export declare type TLDefaultDashStyle = T.TypeOf<typeof DefaultDashStyle>;

/** @public */
export declare type TLDefaultFillStyle = T.TypeOf<typeof DefaultFillStyle>;

/** @public */
export declare type TLDefaultFontStyle = T.TypeOf<typeof DefaultFontStyle>;

/** @public */
export declare type TLDefaultHorizontalAlignStyle = T.TypeOf<typeof DefaultHorizontalAlignStyle>;

/**
 * The default set of shapes that are available in the editor.
 *
 * @public */
export declare type TLDefaultShape = TLArrowShape | TLBookmarkShape | TLDrawShape | TLEmbedShape | TLFrameShape | TLGeoShape | TLGroupShape | TLHighlightShape | TLImageShape | TLLineShape | TLNoteShape | TLTextShape | TLVideoShape;

/** @public */
export declare type TLDefaultSizeStyle = T.TypeOf<typeof DefaultSizeStyle>;

/** @public */
export declare type TLDefaultTextAlignStyle = T.TypeOf<typeof DefaultTextAlignStyle>;

/** @public */
export declare type TLDefaultVerticalAlignStyle = T.TypeOf<typeof DefaultVerticalAlignStyle>;

/**
 * TLDocument
 *
 * @public
 */
export declare interface TLDocument extends BaseRecord<'document', RecordId<TLDocument>> {
    gridSize: number;
    name: string;
    meta: JsonObject;
}

/** @public */
export declare const TLDOCUMENT_ID: RecordId<TLDocument>;

/** @public */
export declare type TLDrawShape = TLBaseShape<'draw', TLDrawShapeProps>;

/** @public */
export declare interface TLDrawShapeProps {
    color: TLDefaultColorStyle;
    fill: TLDefaultFillStyle;
    dash: TLDefaultDashStyle;
    size: TLDefaultSizeStyle;
    segments: TLDrawShapeSegment[];
    isComplete: boolean;
    isClosed: boolean;
    isPen: boolean;
    scale: number;
}

/** @public */
export declare interface TLDrawShapeSegment {
    type: 'free' | 'straight';
    points: VecModel[];
}

/** @public */
export declare type TLEmbedShape = TLBaseShape<'embed', TLEmbedShapeProps>;

/** @public */
export declare type TLEmbedShapePermissions = {
    [K in keyof typeof embedShapePermissionDefaults]?: boolean;
};

/** @public */
export declare interface TLEmbedShapeProps {
    w: number;
    h: number;
    url: string;
}

/** @public */
export declare type TLFrameShape = TLBaseShape<'frame', TLFrameShapeProps>;

/** @public */
export declare interface TLFrameShapeProps {
    w: number;
    h: number;
    name: string;
}

/** @public */
export declare type TLGeoShape = TLBaseShape<'geo', TLGeoShapeProps>;

/** @public */
export declare type TLGeoShapeGeoStyle = T.TypeOf<typeof GeoShapeGeoStyle>;

/** @public */
export declare interface TLGeoShapeProps {
    geo: TLGeoShapeGeoStyle;
    labelColor: TLDefaultColorStyle;
    color: TLDefaultColorStyle;
    fill: TLDefaultFillStyle;
    dash: TLDefaultDashStyle;
    size: TLDefaultSizeStyle;
    font: TLDefaultFontStyle;
    align: TLDefaultHorizontalAlignStyle;
    verticalAlign: TLDefaultVerticalAlignStyle;
    url: string;
    w: number;
    h: number;
    growY: number;
    text: string;
    scale: number;
}

/** @public */
export declare type TLGroupShape = TLBaseShape<'group', TLGroupShapeProps>;

/** @public */
export declare interface TLGroupShapeProps {
}

/**
 * A base interface for a shape's handles.
 *
 * @public
 */
export declare interface TLHandle {
    /** A unique identifier for the handle. */
    id: string;
    type: TLHandleType;
    canSnap?: boolean;
    index: IndexKey;
    x: number;
    y: number;
}

/**
 * A type for the handle types used by tldraw's default shapes.
 *
 * @public */
export declare type TLHandleType = SetValue<typeof TL_HANDLE_TYPES>;

/** @public */
export declare type TLHighlightShape = TLBaseShape<'highlight', TLHighlightShapeProps>;

/** @public */
export declare interface TLHighlightShapeProps {
    color: TLDefaultColorStyle;
    size: TLDefaultSizeStyle;
    segments: TLDrawShapeSegment[];
    isComplete: boolean;
    isPen: boolean;
    scale: number;
}

/**
 * An asset for images such as PNGs and JPEGs, used by the TLImageShape.
 *
 * @public */
export declare type TLImageAsset = TLBaseAsset<'image', {
    fileSize?: number;
    h: number;
    isAnimated: boolean;
    mimeType: null | string;
    name: string;
    src: null | string;
    w: number;
}>;

/** @public */
export declare type TLImageShape = TLBaseShape<'image', TLImageShapeProps>;

/** @public */
export declare interface TLImageShapeCrop {
    topLeft: VecModel;
    bottomRight: VecModel;
}

/** @public */
export declare interface TLImageShapeProps {
    w: number;
    h: number;
    playing: boolean;
    url: string;
    assetId: null | TLAssetId;
    crop: null | TLImageShapeCrop;
    flipX: boolean;
    flipY: boolean;
}

/**
 * TLInstance
 *
 * State that is particular to a single browser tab
 *
 * @public
 */
export declare interface TLInstance extends BaseRecord<'instance', TLInstanceId> {
    currentPageId: TLPageId;
    opacityForNextShape: TLOpacityType;
    stylesForNextShape: Record<string, unknown>;
    followingUserId: null | string;
    highlightedUserIds: string[];
    brush: BoxModel | null;
    cursor: TLCursor;
    scribbles: TLScribble[];
    isFocusMode: boolean;
    isDebugMode: boolean;
    isToolLocked: boolean;
    exportBackground: boolean;
    screenBounds: BoxModel;
    insets: boolean[];
    zoomBrush: BoxModel | null;
    chatMessage: string;
    isChatting: boolean;
    isPenMode: boolean;
    isGridMode: boolean;
    isFocused: boolean;
    devicePixelRatio: number;
    /**
     * This is whether the primary input mechanism includes a pointing device of limited accuracy,
     * such as a finger on a touchscreen.
     * See: https://developer.mozilla.org/en-US/docs/Web/CSS/\@media/pointer
     */
    isCoarsePointer: boolean;
    /**
     * Will be null if the pointer doesn't support hovering (e.g. touch), but true or false
     * otherwise
     */
    isHoveringCanvas: boolean | null;
    openMenus: string[];
    isChangingStyle: boolean;
    isReadonly: boolean;
    meta: JsonObject;
    duplicateProps: {
        offset: {
            x: number;
            y: number;
        };
        shapeIds: TLShapeId[];
    } | null;
}

/** @public */
export declare const TLINSTANCE_ID: TLInstanceId;

/** @public */
export declare type TLInstanceId = RecordId<TLInstance>;

/**
 * TLInstancePageState
 *
 * State that is unique to a particular page of the document in a particular browser tab
 *
 * @public
 */
export declare interface TLInstancePageState extends BaseRecord<'instance_page_state', TLInstancePageStateId> {
    pageId: RecordId<TLPage>;
    selectedShapeIds: TLShapeId[];
    hintingShapeIds: TLShapeId[];
    erasingShapeIds: TLShapeId[];
    hoveredShapeId: null | TLShapeId;
    editingShapeId: null | TLShapeId;
    croppingShapeId: null | TLShapeId;
    focusedGroupId: null | TLShapeId;
    meta: JsonObject;
}

/** @public */
export declare type TLInstancePageStateId = RecordId<TLInstancePageState>;

/** @public */
export declare interface TLInstancePresence extends BaseRecord<'instance_presence', TLInstancePresenceID> {
    userId: string;
    userName: string;
    lastActivityTimestamp: number;
    color: string;
    camera: {
        x: number;
        y: number;
        z: number;
    };
    selectedShapeIds: TLShapeId[];
    currentPageId: TLPageId;
    brush: BoxModel | null;
    scribbles: TLScribble[];
    screenBounds: BoxModel;
    followingUserId: null | string;
    cursor: {
        rotation: number;
        type: TLCursor['type'];
        x: number;
        y: number;
    };
    chatMessage: string;
    meta: JsonObject;
}

/** @public */
export declare type TLInstancePresenceID = RecordId<TLInstancePresence>;

/** @public */
export declare type TLLanguage = (typeof LANGUAGES)[number];

/** @public */
export declare type TLLineShape = TLBaseShape<'line', TLLineShapeProps>;

/** @public */
export declare interface TLLineShapePoint {
    id: string;
    index: IndexKey;
    x: number;
    y: number;
}

/** @public */
export declare interface TLLineShapeProps {
    color: TLDefaultColorStyle;
    dash: TLDefaultDashStyle;
    size: TLDefaultSizeStyle;
    spline: TLLineShapeSplineStyle;
    points: Record<string, TLLineShapePoint>;
    scale: number;
}

/** @public */
export declare type TLLineShapeSplineStyle = T.TypeOf<typeof LineShapeSplineStyle>;

/** @public */
export declare type TLNoteShape = TLBaseShape<'note', TLNoteShapeProps>;

/** @public */
export declare interface TLNoteShapeProps {
    color: TLDefaultColorStyle;
    size: TLDefaultSizeStyle;
    font: TLDefaultFontStyle;
    fontSizeAdjustment: number;
    align: TLDefaultHorizontalAlignStyle;
    verticalAlign: TLDefaultVerticalAlignStyle;
    growY: number;
    url: string;
    text: string;
    scale: number;
}

/** @public */
export declare type TLOpacityType = number;

/**
 * TLPage
 *
 * @public
 */
export declare interface TLPage extends BaseRecord<'page', TLPageId> {
    name: string;
    index: IndexKey;
    meta: JsonObject;
}

/** @public */
export declare type TLPageId = RecordId<TLPage>;

/** @public */
export declare type TLParentId = TLPageId | TLShapeId;

/**
 * TLPointer
 *
 * @public
 */
export declare interface TLPointer extends BaseRecord<'pointer', TLPointerId> {
    x: number;
    y: number;
    lastActivityTimestamp: number;
    meta: JsonObject;
}

/** @public */
export declare const TLPOINTER_ID: TLPointerId;

/** @public */
export declare type TLPointerId = RecordId<TLPointer>;

/**
 * @public
 */
export declare interface TLPropsMigration {
    readonly id: MigrationId;
    readonly dependsOn?: MigrationId[];
    readonly up: (props: any) => any;
    /**
     * If a down migration was deployed more than a couple of months ago it should be safe to retire it.
     * We only really need them to smooth over the transition between versions, and some folks do keep
     * browser tabs open for months without refreshing, but at a certain point that kind of behavior is
     * on them. Plus anyway recently chrome has started to actually kill tabs that are open for too long
     * rather than just suspending them, so if other browsers follow suit maybe it's less of a concern.
     *
     * @public
     */
    readonly down?: 'none' | 'retired' | ((props: any) => any);
}

/**
 * @public
 */
export declare interface TLPropsMigrations {
    readonly sequence: Array<StandaloneDependsOn | TLPropsMigration>;
}

/** @public */
export declare type TLRecord = TLAsset | TLBinding | TLCamera | TLDocument | TLInstance | TLInstancePageState | TLInstancePresence | TLPage | TLPointer | TLShape;

/** @public */
export declare type TLSchema = StoreSchema<TLRecord, TLStoreProps>;

/**
 * A type for the scribble used by tldraw.
 *
 * @public */
export declare interface TLScribble {
    id: string;
    points: VecModel[];
    size: number;
    color: TLCanvasUiColor;
    opacity: number;
    state: SetValue<typeof TL_SCRIBBLE_STATES>;
    delay: number;
    shrink: number;
    taper: boolean;
}

/** @public */
export declare type TLSerializedStore = SerializedStore<TLRecord>;

/**
 * The set of all shapes that are available in the editor, including unknown shapes.
 *
 * @public
 */
export declare type TLShape = TLDefaultShape | TLUnknownShape;

/** @public */
export declare type TLShapeId = RecordId<TLUnknownShape>;

/** @public */
export declare type TLShapePartial<T extends TLShape = TLShape> = T extends T ? {
    id: TLShapeId;
    meta?: Partial<T['meta']>;
    props?: Partial<T['props']>;
    type: T['type'];
} & Partial<Omit<T, 'id' | 'meta' | 'props' | 'type'>> : never;

/** @public */
export declare type TLStore = Store<TLRecord, TLStoreProps>;

/** @public */
export declare interface TLStoreProps {
    defaultName: string;
    assets: Required<TLAssetStore>;
    /**
     * Called an {@link @tldraw/editor#Editor} connected to this store is mounted.
     */
    onMount(editor: unknown): (() => void) | void;
    collaboration?: {
        status: null | Signal<'offline' | 'online'>;
    };
}

/** @public */
export declare type TLStoreSchema = StoreSchema<TLRecord, TLStoreProps>;

/** @public */
export declare type TLStoreSnapshot = StoreSnapshot<TLRecord>;

/** @public */
export declare type TLTextShape = TLBaseShape<'text', TLTextShapeProps>;

/** @public */
export declare interface TLTextShapeProps {
    color: TLDefaultColorStyle;
    size: TLDefaultSizeStyle;
    font: TLDefaultFontStyle;
    textAlign: TLDefaultTextAlignStyle;
    w: number;
    text: string;
    scale: number;
    autoSize: boolean;
}

/**
 * A type for a binding that is available in the editor but whose type is
 * unknown—either one of the editor's default bindings or else a custom binding.
 *
 * @public */
export declare type TLUnknownBinding = TLBaseBinding<string, object>;

/**
 * A type for a shape that is available in the editor but whose type is
 * unknown—either one of the editor's default shapes or else a custom shape.
 *
 * @public */
export declare type TLUnknownShape = TLBaseShape<string, object>;

/**
 * An asset used for videos, used by the TLVideoShape.
 *
 * @public */
export declare type TLVideoAsset = TLBaseAsset<'video', {
    fileSize?: number;
    h: number;
    isAnimated: boolean;
    mimeType: null | string;
    name: string;
    src: null | string;
    w: number;
}>;

/** @public */
export declare type TLVideoShape = TLBaseShape<'video', TLVideoShapeProps>;

/** @public */
export declare interface TLVideoShapeProps {
    w: number;
    h: number;
    time: number;
    playing: boolean;
    url: string;
    assetId: null | TLAssetId;
}

/**
 * A serializable model for 2D vectors.
 *
 * @public */
export declare interface VecModel {
    x: number;
    y: number;
    z?: number;
}

/** @public */
export declare const vecModelValidator: T.ObjectValidator<VecModel>;

/** @public */
export declare const videoShapeMigrations: TLPropsMigrations;

/** @public */
export declare const videoShapeProps: RecordProps<TLVideoShape>;

export { }
